CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE upper(TABLE_NAME) = 'PDV_VD_IT_IBS_CBS') THEN 
        CREATE TABLE PDV_VD_IT_IBS_CBS
			(
				CD_EMP                   integer NOT NULL,
				CD_FILIAL                integer NOT NULL,
				CD_VD                    integer NOT NULL,
				CD_IT                    integer NOT NULL,
				CD_PROD                  integer,
				CD_TRIB_IBS_CBS          integer,
				CST_IBS_CBS              varchar(3),
				CLASS_TRIB_IBS_CBS       varchar(6),
				VLR_BC_IBS_CBS           numeric(18,2),
				PERC_IBS_UF              numeric(18,2),
				PERC_IBS_UF_DIFERIMENTO  numeric(18,2),
				VLR_IBS_UF_DIFERIMENTO   numeric(18,2),
				VLR_IBS_UF_DEV_TRIB      numeric(18,2),
				PERC_IBS_UF_RED          numeric(18,2),
				PERC_IBS_UF_RED_EFET     numeric(18,2),
				VLR_IBS_UF               numeric(18,2),
				PERC_IBS_MUN             numeric(18,2),
				PERC_IBS_MUN_DIFERIMENTO numeric(18,2),
				VLR_IBS_MUN_DIFERIMENTO  numeric(18,2),
				VLR_IBS_MUN_DEV_TRIB     numeric(18,2),
				PERC_IBS_MUN_RED         numeric(18,2),
				PERC_IBS_MUN_RED_EFET    numeric(18,2),
				VLR_IBS_MUN              numeric(18,2),
				VLR_IBS                  numeric(18,2),
				PERC_CBS                 numeric(18,2),
				PERC_CBS_DIFERIMENTO     numeric(18,2),
				VLR_CBS_DIFERIMENTO      numeric(18,2),
				VLR_CBS_DEV_TRIB         numeric(18,2),
				PERC_CBS_RED             numeric(18,2),
				PERC_CBS_RED_EFET        numeric(18,2),
				VLR_CBS                  numeric(18,2),

				CONSTRAINT PK_PDV_VD_IT_IBS_CBS PRIMARY KEY (CD_EMP, CD_FILIAL, CD_VD, CD_IT)
			)
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA PDV_VD_IT_IBS_CBS %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();

